unit Main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ActiveX, ComObj, OleServer, WordXP, ExtCtrls, RzTabs,
  ShellAPI, RzPanel, Mask, RzEdit, RzButton, RzLabel, RzCmboBx, RzLstBox,
  ComCtrls, RzListVw, RzBorder, RzShellDialogs, AddFilesFrm, HTMLEditFrm,
  HTMLFrm, Htmlview, INI, RzStatus, SkinCaption, WinSkinData;

type
  TFastContentProducerForm = class(TForm)
    Image1: TImage;
    BigPages: TRzPageControl;
    TabSheet1: TRzTabSheet;
    TabSheet2: TRzTabSheet;
    TabSheet3: TRzTabSheet;
    MainPages: TRzPageControl;
    TabSheet4: TRzTabSheet;
    TabSheet5: TRzTabSheet;
    TabSheet6: TRzTabSheet;
    TabSheet7: TRzTabSheet;
    RzPanel1: TRzPanel;
    RzPanel2: TRzPanel;
    RzPanel3: TRzPanel;
    RzPanel4: TRzPanel;
    RzPanel5: TRzPanel;
    RzPanel6: TRzPanel;
    RzPanel7: TRzPanel;
    ContentFile: TRzEdit;
    PageTemplate: TRzEdit;
    OutputLocation: TRzEdit;
    RzGroupBox1: TRzGroupBox;
    btnClear1: TRzButton;
    RzLabel1: TRzLabel;
    RzLabel2: TRzLabel;
    RzLabel3: TRzLabel;
    RzLabel4: TRzLabel;
    btnSave1: TRzButton;
    RzLabel6: TRzLabel;
    CharsPerPage: TRzEdit;
    ContentType: TRzComboBox;
    RzLabel7: TRzLabel;
    PageBreak: TRzEdit;
    btnOpenContentFile: TRzBitBtn;
    btnOpenPageTemplate: TRzBitBtn;
    btnOutputLocation: TRzBitBtn;
    btnPreviewPageTemplate: TRzBitBtn;
    btnSelectMoreContentFiles: TRzBitBtn;
    RzPanel8: TRzPanel;
    RzLabel8: TRzLabel;
    RzGroupBox2: TRzGroupBox;
    RzLabel9: TRzLabel;
    RSSURL: TRzEdit;
    btnPreviewRSS: TRzBitBtn;
    FeedsList: TRzListBox;
    RzLabel10: TRzLabel;
    btnClearFeeds: TRzBitBtn;
    btnAddFeed: TRzButton;
    RzGroupBox3: TRzGroupBox;
    btnClear2: TRzButton;
    btnSave2: TRzButton;
    RzLabel11: TRzLabel;
    btnClearAffiliateCodes: TRzBitBtn;
    RzPanel9: TRzPanel;
    RzLabel12: TRzLabel;
    RzGroupBox4: TRzGroupBox;
    RzLabel14: TRzLabel;
    btnClearFormCode: TRzBitBtn;
    btnPrevious2: TRzButton;
    btnClear3: TRzButton;
    btnPrevious3: TRzButton;
    btnSave3: TRzButton;
    btnFormBuilder: TRzButton;
    RzLabel13: TRzLabel;
    btnHTMLEditor: TRzButton;
    btnClearBottomLinks: TRzBitBtn;
    FormCode: TRzMemo;
    BottomLinks: TRzMemo;
    KeywordLinks: TRzMemo;
    btnClearKeywordLinks: TRzBitBtn;
    RzGroupBox5: TRzGroupBox;
    editLinkURL: TRzEdit;
    editLinkText: TRzEdit;
    btnInsertKeywordLink: TRzButton;
    RzPanel10: TRzPanel;
    RzLabel15: TRzLabel;
    btnClear4: TRzButton;
    btnPrevious4: TRzButton;
    btnSaveAndCreatePages: TRzButton;
    btnSave4: TRzButton;
    RzGroupBox6: TRzGroupBox;
    btnPreviewOnePage: TRzButton;
    btnFTP: TRzButton;
    RzLabel16: TRzLabel;
    HeaderTitle: TRzEdit;
    HeaderSlogan: TRzEdit;
    RzLabel17: TRzLabel;
    RzLabel18: TRzLabel;
    Prefix: TRzEdit;
    PrefixType: TRzComboBox;
    RzLabel20: TRzLabel;
    RzLabel19: TRzLabel;
    HeaderLogo: TRzEdit;
    HeaderOnPage: TRzComboBox;
    RzLabel21: TRzLabel;
    RzLabel22: TRzLabel;
    btnSelectHeaderLogo: TRzBitBtn;
    ProjectsList: TRzListView;
    btnRunProject: TRzBitBtn;
    btnEditProject: TRzBitBtn;
    btnDeleteProject: TRzBitBtn;
    btnCreateNewProject: TRzBitBtn;
    RzGroupBox7: TRzGroupBox;
    OpenDialog: TRzOpenDialog;
    SelectFolderDialog: TRzSelectFolderDialog;
    AffiliateCodes: TRzMemo;
    HTMLPreview: THTMLViewer;
    lblTotalC: TRzLabel;
    lblTotalW: TRzLabel;
    PBar: TRzProgressStatus;
    SkinData: TSkinData;
    SkinCaption: TSkinCaption;
    ProjectName: TRzEdit;
    Label1: TLabel;
    RzButton1: TRzButton;
    RzButton2: TRzButton;
    RzButton3: TRzButton;
    RzButton: TRzButton;
    procedure Image1Click(Sender: TObject);
    procedure btnPreviewPageTemplateClick(Sender: TObject);
    procedure btnOutputLocationClick(Sender: TObject);
    procedure btnOpenPageTemplateClick(Sender: TObject);
    procedure btnOpenContentFileClick(Sender: TObject);
    procedure RzURLLabel1Click(Sender: TObject);
    procedure RzURLLabel2Click(Sender: TObject);
    procedure RzURLLabel4Click(Sender: TObject);
    procedure btnClear1Click(Sender: TObject);
    procedure ContentTypeChange(Sender: TObject);
    procedure btnSelectMoreContentFilesClick(Sender: TObject);
    procedure btnClearFeedsClick(Sender: TObject);
    procedure btnAddFeedClick(Sender: TObject);
    procedure btnPreviewRSSClick(Sender: TObject);
    procedure btnClearAffiliateCodesClick(Sender: TObject);
    procedure btnClear2Click(Sender: TObject);
    procedure btnPrevious2Click(Sender: TObject);
    procedure btnPrevious3Click(Sender: TObject);
    procedure btnPrevious4Click(Sender: TObject);
    procedure btnClearFormCodeClick(Sender: TObject);
    procedure btnClearBottomLinksClick(Sender: TObject);
    procedure btnClearKeywordLinksClick(Sender: TObject);
    procedure btnClear3Click(Sender: TObject);
    procedure btnInsertKeywordLinkClick(Sender: TObject);
    procedure btnSave3Click(Sender: TObject);
    procedure btnSave1Click(Sender: TObject);
    procedure btnSave2Click(Sender: TObject);
    procedure btnFormBuilderClick(Sender: TObject);
    procedure btnHTMLEditorClick(Sender: TObject);
    procedure btnSelectHeaderLogoClick(Sender: TObject);
    procedure btnSaveAndCreatePagesClick(Sender: TObject);
    procedure btnSave4Click(Sender: TObject);
    procedure ContentFileChange(Sender: TObject);
    procedure btnFTPClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure btnEditProjectClick(Sender: TObject);
    procedure btnDeleteProjectClick(Sender: TObject);
    procedure btnCreateNewProjectClick(Sender: TObject);
    procedure btnRunProjectClick(Sender: TObject);
    procedure btnPreviewOnePageClick(Sender: TObject);
    procedure RzButton3Click(Sender: TObject);
  private
    { Private declarations }
    function CountWords(FileName: String): Integer;
    function CountCharacters(FileName: String): Integer;
  public
    { Public declarations }
    procedure CreateNewProject;
    procedure RunProject(ProjectName: String);
    procedure SaveCurrentProject;
    procedure SaveDOCasTEXT(LoadFromDOCFile, SaveToTXTFile: String);
    procedure LoadProject(ProjectName: String);
    procedure LoadProjects;
  end;

const
  ContentFileFilter = 'All documents (*.DOC, *.TXT, *.RTF)|*.doc;*.txt;*.rtf';
  PageTemplateFilter = 'HTML documents (*.HTM, *.HTML)|*.htm;*.html';
  ImageFilter = 'Known images (*.GIF, *.JPG)|*.gif;*.jpg;*.jpeg';

var
  FastContentProducerForm: TFastContentProducerForm;

implementation

{$R *.dfm}

function UrlEncode(const DecodedStr: String; Pluses: Boolean): String;
var
  I: Integer;
begin
  Result := '';
  if Length(DecodedStr) > 0 then
    for I := 1 to Length(DecodedStr) do
    begin
      if not (DecodedStr[I] in ['0'..'9', 'a'..'z',
                                       'A'..'Z', ' ']) then
        Result := Result + '%' + IntToHex(Ord(DecodedStr[I]), 2)
      else if not (DecodedStr[I] = ' ') then
        Result := Result + DecodedStr[I]
      else
        begin
          if not Pluses then
            Result := Result + '%20'
          else
            Result := Result + '+';
        end;
    end;
end;

function CopyDir(const fromDir, toDir: string): Boolean;
var
  fos: TSHFileOpStruct;
begin
  ZeroMemory(@fos, SizeOf(fos));
  with fos do
  begin
    wFunc  := FO_COPY;
    fFlags := FOF_NOCONFIRMATION or FOF_SILENT{ or FOF_FILESONLY};
    pFrom  := PChar(fromDir + #0);
    pTo    := PChar(toDir)
  end;
  Result := (0 = ShFileOperation(fos));
end;

function MoveDir(const fromDir, toDir: string): Boolean;
var
  fos: TSHFileOpStruct;
begin
  ZeroMemory(@fos, SizeOf(fos));
  with fos do
  begin
    wFunc  := FO_MOVE;
    fFlags := FOF_NOCONFIRMATION or FOF_SILENT{ or FOF_FILESONLY};
    pFrom  := PChar(fromDir + #0);
    pTo    := PChar(toDir)
  end;
  Result := (0 = ShFileOperation(fos));
end;

function DelDir(dir: string): Boolean;
var
  fos: TSHFileOpStruct;
begin
  ZeroMemory(@fos, SizeOf(fos));
  with fos do
  begin
    wFunc  := FO_DELETE;
    fFlags := FOF_SILENT or FOF_NOCONFIRMATION;
    pFrom  := PChar(dir + #0);
  end;
  Result := (0 = ShFileOperation(fos));
end;

function IsCharAlpha(S: Char): Boolean;
begin
  Result := S <> ' ';
end;

procedure SplitTextIntoWords(const S: string; words: TstringList);
var
  startpos, endpos: Integer;
begin
  Assert(Assigned(words));
  words.Clear;
  startpos := 1;
  while startpos <= Length(S) do
  begin
    while (startpos <= Length(S)) and not IsCharAlpha(S[startpos]) do
      Inc(startpos);
    if startpos <= Length(S) then
    begin
      endpos := startpos + 1;
      while (endpos <= Length(S)) and IsCharAlpha(S[endpos]) do
        Inc(endpos);
      words.Add(Copy(S, startpos, endpos - startpos));
      startpos := endpos + 1;
    end; { If }
  end; { While }
end; { SplitTextIntoWords }

function StringMatchesMask(S, mask: string;
  case_sensitive: Boolean): Boolean; 
var
  sIndex, maskIndex: Integer; 
begin 
  if not case_sensitive then 
  begin 
    S    := AnsiUpperCase(S); 
    mask := AnsiUpperCase(mask); 
  end; { If } 
  Result    := True; // blatant optimism 
  sIndex    := 1; 
  maskIndex := 1; 
  while (sIndex <= Length(S)) and (maskIndex <= Length(mask)) do 
  begin 
    case mask[maskIndex] of 
      '?': 
        begin 
          Inc(sIndex); 
          Inc(maskIndex); 
        end; { case '?' } 
      '*': 
        begin 
          Inc(maskIndex); 
          if maskIndex > Length(mask) then 
            Exit 
          else if mask[maskindex] in ['*', '?'] then 
            raise Exception.Create('Invalid mask'); 
          while (sIndex <= Length(S)) and
            (S[sIndex] <> mask[maskIndex]) do 
            Inc(sIndex); 
          if sIndex > Length(S) then 
          begin 
            Result := False; 
            Exit; 
          end; 
          { If }
        end; { Case '*' } 
      else if S[sIndex] = mask[maskIndex] then 
        begin 
          Inc(sIndex); 
          Inc(maskIndex); 
        end { If } 
        else 
          begin 
            Result := False; 
            Exit; 
          end; 
    end; { Case } 
  end; { While } 
  if (sIndex <= Length(S)) or (maskIndex <= Length(mask)) then 
    Result := False; 
end; { stringMatchesMask } 

procedure FindMatchingWords(const S, mask: string;
  case_sensitive: Boolean; matches: Tstrings); 
var 
  words: TstringList; 
  i: Integer; 
begin 
  Assert(Assigned(matches)); 
  words := TstringList.Create; 
  try 
    SplitTextIntoWords(S, words); 
    matches.Clear; 
    for i := 0 to words.Count - 1 do 
    begin 
      if stringMatchesMask(words[i], mask, case_sensitive) then
        matches.Add(words[i]);
    end; { For }
  finally
    words.Free;
  end;
end;

procedure TFastContentProducerForm.SaveDOCasTEXT(LoadFromDOCFile, SaveToTXTFile: String);
var WordApp, Doc: Variant;
begin
  WordApp := CreateOleObject('Word.Application');
  Doc := WordApp.Documents.Open(FileName := LoadFromDOCFile);
  Doc.SaveAs(FileName := SaveToTXTFile,  FileFormat := wdFormatText,  AddToRecentFiles := False);
  WordApp.Quit();
end;

procedure TFastContentProducerForm.Image1Click(Sender: TObject);
begin
  ShellExecute(Handle, 'open', 'http://www.google.com', '', '', SW_SHOWNORMAL);
end;

procedure TFastContentProducerForm.btnPreviewPageTemplateClick(Sender: TObject);
begin
  if Trim(PageTemplate.Text) = '' then
  begin
    Application.MessageBox('Please enter a valid page template!', 'Warning', MB_OK+MB_ICONWARNING);
    Exit;
  end;
  ShellExecute(Handle, 'open', PChar(PageTemplate.Text), '', '', SW_SHOWNORMAL);
end;

procedure TFastContentProducerForm.btnOutputLocationClick(Sender: TObject);
begin
  if SelectFolderDialog.Execute then
   OutputLocation.Text := SelectFolderDialog.SelectedFolder.PathName;
end;

procedure TFastContentProducerForm.btnOpenPageTemplateClick(Sender: TObject);
begin
  OpenDialog.Filter := PageTemplateFilter;
  OpenDialog.InitialDir := ExtractFilePath(ParamStr(0))+'Themes';
  if OpenDialog.Execute then
    PageTemplate.Text := OpenDialog.FileName;
end;

procedure TFastContentProducerForm.btnOpenContentFileClick(Sender: TObject);
begin
  OpenDialog.Filter := ContentFileFilter;
  OpenDialog.InitialDir := ExtractFilePath(ParamStr(0));
  if OpenDialog.Execute then
    ContentFile.Text := OpenDialog.FileName;
end;

procedure TFastContentProducerForm.RzURLLabel1Click(Sender: TObject);
begin
  ShellExecute(Handle, 'open', PChar(ExtractFilePath(ParamStr(0))+'Themes'), '', '', SW_SHOWNORMAL);
end;

procedure TFastContentProducerForm.RzURLLabel2Click(Sender: TObject);
begin
  ShellExecute(Handle, 'open', PChar(ExtractFilePath(ParamStr(0))+'Sample'), '', '', SW_SHOWNORMAL);
end;

procedure TFastContentProducerForm.RzURLLabel4Click(Sender: TObject);
begin
  ShellExecute(Handle, 'open', PChar(ExtractFilePath(ParamStr(0))+'Themes\Images'), '', '', SW_SHOWNORMAL);
end;

procedure TFastContentProducerForm.btnClear1Click(Sender: TObject);
begin
  ProjectName.Text := '';
  ContentFile.Text := '';
  PageTemplate.Text := '';
  OutputLocation.Text := '';
  CharsPerPage.Text := '';
  ContentType.ItemIndex := 0;
  PageBreak.Text := '';
end;

procedure TFastContentProducerForm.ContentTypeChange(Sender: TObject);
begin
  PageBreak.Enabled := ContentType.ItemIndex = 0;
end;

procedure TFastContentProducerForm.btnSelectMoreContentFilesClick(Sender: TObject);
var I: Integer;
    S: String;
begin
  with TAddFilesForm.Create(Self) do
  try
    PrepareList(ContentFile.Text);
    ShowModal;
    if ModalResult = mrOK then
    begin
      S := '';
      for I:=0 to FilesList.Items.Count-1 do
        S := S + '|' + FilesList.Items[I];
      if S<>'' then
       Delete(S, 1, 1);
      ContentFile.Text := S;
    end;
  finally
    Free;
  end;
end;

procedure TFastContentProducerForm.btnClearFeedsClick(Sender: TObject);
begin
  FeedsList.Items.Clear;
end;

procedure TFastContentProducerForm.btnAddFeedClick(Sender: TObject);
begin
  if Trim(RSSURL.Text) <> '' then
    FeedsList.Items.Add(RSSURL.Text);
end;

procedure TFastContentProducerForm.btnPreviewRSSClick(Sender: TObject);
begin
  if Trim(RSSURL.Text) = '' then
  begin
    Application.MessageBox('Please enter a valid RSS URL!', 'Warning', MB_OK+MB_ICONWARNING);
    Exit;
  end;
  ShellExecute(Handle, 'open', PChar(RSSURL.Text), '', '', SW_SHOWNORMAL);
end;

procedure TFastContentProducerForm.btnClearAffiliateCodesClick(Sender: TObject);
begin
  AffiliateCodes.Lines.Text := '';
end;

procedure TFastContentProducerForm.btnClear2Click(Sender: TObject);
begin
  FeedsList.Items.Clear;
  RSSURL.Text := '';
  AffiliateCodes.Lines.Text := '';
end;

procedure TFastContentProducerForm.btnPrevious2Click(Sender: TObject);
begin
  MainPages.ActivePageIndex := 0;
end;

procedure TFastContentProducerForm.btnPrevious3Click(Sender: TObject);
begin
  MainPages.ActivePageIndex := 1;
end;

procedure TFastContentProducerForm.btnPrevious4Click(Sender: TObject);
begin
  MainPages.ActivePageIndex := 2;
end;

procedure TFastContentProducerForm.btnClearFormCodeClick(Sender: TObject);
begin
  FormCode.Lines.Text := '';
end;

procedure TFastContentProducerForm.btnClearBottomLinksClick(Sender: TObject);
begin
  BottomLinks.Lines.Text := '';
end;

procedure TFastContentProducerForm.btnClearKeywordLinksClick(Sender: TObject);
begin
  KeywordLinks.Lines.Text := '';
end;

procedure TFastContentProducerForm.btnClear3Click(Sender: TObject);
begin
  editLinkURL.Text := 'Link URL';
  editLinkText.Text := 'Link Text';
  FormCode.Lines.Text := '';
  BottomLinks.Lines.Text := '';
  KeywordLinks.Lines.Text := '';
end;

procedure TFastContentProducerForm.btnInsertKeywordLinkClick(Sender: TObject);
begin
  if Trim(KeywordLinks.Text) = '' then
   KeywordLinks.Text := editLinkURL.Text+'|'+editLinkText.Text
  else
   KeywordLinks.Text := KeywordLinks.Text+','+editLinkURL.Text+'|'+editLinkText.Text
end;

procedure TFastContentProducerForm.btnSave3Click(Sender: TObject);
begin
  MainPages.ActivePageIndex := 3;
end;

procedure TFastContentProducerForm.btnSave1Click(Sender: TObject);
begin
  MainPages.ActivePageIndex := 1;
end;

procedure TFastContentProducerForm.btnSave2Click(Sender: TObject);
begin
  MainPages.ActivePageIndex := 2;
end;

procedure TFastContentProducerForm.btnFormBuilderClick(Sender: TObject);
begin
  with HTMLForm do
  try
    ShowModal;
    if ModalResult = mrOK then
     FormCode.Lines.Text := PrepareText;
  finally
  end;
end;

procedure TFastContentProducerForm.btnHTMLEditorClick(Sender: TObject);
begin
  with THTMLEditForm.Create(Self) do
  try
    HTMLMemo.Text := BottomLinks.Lines.Text;
    ShowModal;
    if ModalResult = mrOK then
      BottomLinks.Lines.Text := HTMLMemo.Text;
  finally
    Free;
  end;
end;

procedure TFastContentProducerForm.btnSelectHeaderLogoClick(Sender: TObject);
begin
  OpenDialog.Filter := ImageFilter;
  OpenDialog.InitialDir := ExtractFilePath(ParamStr(0))+'Themes\Images';
  if OpenDialog.Execute then
    HeaderLogo.Text := OpenDialog.FileName;
end;

procedure TFastContentProducerForm.btnSaveAndCreatePagesClick(Sender: TObject);
begin
  SaveCurrentProject;
  RunProject(ProjectName.Text);
end;

procedure TFastContentProducerForm.btnSave4Click(Sender: TObject);
begin
  SaveCurrentProject;
  Application.MessageBox('Project has been saved!', 'Information', MB_OK+MB_ICONINFORMATION);
end;

procedure TFastContentProducerForm.SaveCurrentProject;
var I: Integer;
    INI: TBigINIFile;
    S: String;
    Found: Boolean;
    Item: TListItem;
begin
  { Saving our current project }
  if Trim(ProjectName.Text) = '' then
  begin
    Application.MessageBox('Please enter a valid project title in the Step 1 - Basic tab!', 'Warning', MB_OK+MB_ICONWARNING);
    Exit;
  end;
  Found := False;
  for I:=0 to ProjectsList.Items.Count-1 do
   if UpperCase(ProjectsList.Items[I].Caption) = UpperCase(ProjectName.Text) then
   begin
     Found := True;
     Break;
   end;
  begin
    if not Found then
    begin
      Item := ProjectsList.Items.Add;
      Item.Caption := ProjectName.Text;
      Item.SubItems.Add('N/A');
      Item.SubItems.Add(OutputLocation.Text);
    end;

    INI := TBigINIFile.Create(ExtractFilePath(ParamStr(0))+'Projects.ini');

    INI.WriteString(ProjectName.Text, 'ProjectName', ProjectName.Text); // might differ casing
    INI.WriteString(ProjectName.Text, 'ContentFile', ContentFile.Text);
    INI.WriteString(ProjectName.Text, 'PageTemplate', PageTemplate.Text);
    INI.WriteString(ProjectName.Text, 'OutputLocation', OutputLocation.Text);
    INI.WriteString(ProjectName.Text, 'CharsPerPage', CharsPerPage.Text);
    INI.WriteInteger(ProjectName.Text, 'ContentType', ContentType.ItemIndex);
    INI.WriteString(ProjectName.Text, 'PageBreak', PageBreak.Text);

    S := FeedsList.Items.GetText;
    S := StringReplace(S, #13#10, '~$~', [rfReplaceAll]);
    INI.WriteString(ProjectName.Text, 'FeedsList', S);
    S := AffiliateCodes.Lines.GetText;
    S := StringReplace(S, #13#10, '~$~', [rfReplaceAll]);
    INI.WriteString(ProjectName.Text, 'AffiliateCodes', S);

    S := FormCode.Lines.GetText;
    S := StringReplace(S, #13#10, '~$~', [rfReplaceAll]);
    INI.WriteString(ProjectName.Text, 'FormCode', S);
    S := BottomLinks.Lines.GetText;
    S := StringReplace(S, #13#10, '~$~', [rfReplaceAll]);
    INI.WriteString(ProjectName.Text, 'BottomLinks', S);
    S := KeywordLinks.Lines.GetText;
    S := StringReplace(S, #13#10, '~$~', [rfReplaceAll]);
    INI.WriteString(ProjectName.Text, 'KeywordLinks', S);

    INI.WriteString(ProjectName.Text, 'HeaderTitle', HeaderTitle.Text);
    INI.WriteString(ProjectName.Text, 'HeaderSlogan', HeaderSlogan.Text);
    INI.WriteString(ProjectName.Text, 'Prefix', Prefix.Text);
    INI.WriteInteger(ProjectName.Text, 'PrefixType', PrefixType.ItemIndex);
    INI.WriteString(ProjectName.Text, 'HeaderLogo', HeaderLogo.Text);
    INI.WriteString(ProjectName.Text, 'HeaderOnPage', HeaderOnPage.Text);

    INI.WriteString(ProjectName.Text, 'LastRun', 'N/A');

    INI.Free;
  end;
end;

procedure TFastContentProducerForm.ContentFileChange(Sender: TObject);
var TC, TW, A, B: Integer;
    S: String;
begin
  if Trim(ContentFile.Text) = '' then
  begin
    lblTotalW.Caption := '0 total words';
    lblTotalC.Caption := '0 total characters';
  end
  else
  begin
    S := ContentFile.Text;
    TC := 0;
    TW := 0;
    while Pos('|', S) > 0 do
    begin
      if Trim(Copy(S, 1, Pos('|', S)-1)) <> '' then
      begin
        A := CountWords(Copy(S, 1, Pos('|', S)-1));
        B := CountCharacters(Copy(S, 1, Pos('|', S)-1));
        Inc(TC, B);
        Inc(TW, A);
      end;
      Delete(S, 1, Pos('|', S));
    end;
   if Trim(S) <> '' then
    begin
      A := CountWords(S);
      B := CountCharacters(S);
      Inc(TC, B);
      Inc(TW, A);
    end;
    lblTotalW.Caption := FloatToStrF(TW, ffNumber, 18, 0)+' total words';
    lblTotalC.Caption := FloatToStrF(TC, ffNumber, 18, 0)+' total characters';
  end;
end;

function TFastContentProducerForm.CountWords(FileName: String): Integer;
var List: TStringList;
begin
  try
    List := TStringList.Create;
    List.LoadFromFile(FileName);
    SplitTextIntoWords(List.Text, List);
    Result := List.Count;
    List.Free;
  except
    List.Free;
    Result := 0;
  end;
end;
                       
function TFastContentProducerForm.CountCharacters(FileName: String): Integer;
var List: TStringList;
begin
  try
    List := TStringList.Create;
    List.LoadFromFile(FileName);
    Result := Length(List.Text);
    List.Free;
  except
    List.Free;
    Result := 0;
  end;
end;

procedure TFastContentProducerForm.btnFTPClick(Sender: TObject);
begin
  ShellExecute(Handle, 'open', PChar(ExtractFilePath(ParamStr(0))+'FTP.exe'), '', '', SW_SHOWNORMAL);
end;

procedure TFastContentProducerForm.FormCreate(Sender: TObject);
begin
  LoadProjects;
end;

procedure TFastContentProducerForm.LoadProjects;
var INI: TBigINIFile;
    List: TStringList;
    I: Integer;
    Item: TListItem;
begin
  ProjectsList.Items.Clear;
  INI := TBigINIFile.Create(ExtractFilePath(ParamStr(0))+'Projects.ini');
  List := TStringList.Create;
  INI.ReadSections(List);
  for I:=0 to List.Count-1 do
  begin
    Item := ProjectsList.Items.Add;
    Item.Caption := List[I];
    Item.SubItems.Add(INI.ReadString(List[I], 'LastRun', 'N/A'));
    Item.SubItems.Add(INI.ReadString(List[I], 'OutputLocation', ''));
  end;
  List.Free;
  INI.Free;
end;

procedure TFastContentProducerForm.btnEditProjectClick(Sender: TObject);
begin
  if ProjectsList.ItemIndex > -1 then
  begin
    LoadProject(ProjectsList.Items[ProjectsList.ItemIndex].Caption);
    Application.MessageBox('Project loaded successfully!', 'Information', MB_OK+MB_ICONINFORMATION);
  end;
end;

procedure TFastContentProducerForm.LoadProject(ProjectName: String);
var INI: TBigINIFile;
    S: String;
begin
  INI := TBigINIFile.Create(ExtractFilePath(ParamStr(0))+'Projects.ini');

  Self.ProjectName.Text := INI.ReadString(ProjectName, 'ProjectName', '');
  ContentFile.Text := INI.ReadString(ProjectName, 'ContentFile', '');
  ContentFileChange(Self);
  PageTemplate.Text := INI.ReadString(ProjectName, 'PageTemplate', '');
  OutputLocation.Text := INI.ReadString(ProjectName, 'OutputLocation', '');
  CharsPerPage.Text := INI.ReadString(ProjectName, 'CharsPerPage', '');
  ContentType.ItemIndex := INI.ReadInteger(ProjectName, 'ContentType', 0);
  PageBreak.Text := INI.ReadString(ProjectName, 'PageBreak', '');

  FeedsList.Clear;
  S := INI.ReadString(ProjectName, 'FeedsList', '');
  S := StringReplace(S, '~$~', #13#10, [rfReplaceAll]);
  FeedsList.Items.Text := S;
  RSSURL.Text := '';
  AffiliateCodes.Clear;
  S := INI.ReadString(ProjectName, 'AffiliateCodes', '');
  S := StringReplace(S, '~$~', #13#10, [rfReplaceAll]);
  AffiliateCodes.Lines.Text := S;

  FormCode.Clear;
  S := INI.ReadString(ProjectName, 'FormCode', '');
  S := StringReplace(S, '~$~', #13#10, [rfReplaceAll]);
  FormCode.Lines.Text := S;
  BottomLinks.Clear;
  S := INI.ReadString(ProjectName, 'BottomLinks', '');
  S := StringReplace(S, '~$~', #13#10, [rfReplaceAll]);
  BottomLinks.Lines.Text := S;
  KeywordLinks.Clear;
  S := INI.ReadString(ProjectName, 'KeywordLinks', '');
  S := StringReplace(S, '~$~', #13#10, [rfReplaceAll]);
  KeywordLinks.Lines.Text := S;
  editLinkURL.Text := 'Link URL';
  editLinkText.Text := 'Link Text';

  HeaderTitle.Text := INI.ReadString(ProjectName, 'HeaderTitle', '');
  HeaderSlogan.Text := INI.ReadString(ProjectName, 'HeaderSlogan', '');
  Prefix.Text := INI.ReadString(ProjectName, 'Prefix', '');
  PrefixType.ItemIndex := INI.ReadInteger(ProjectName, 'PrefixType', 0);
  HeaderLogo.Text := INI.ReadString(ProjectName, 'HeaderLogo', '');
  HeaderOnPage.Text := INI.ReadString(ProjectName, 'HeaderOnPage', '');

  INI.Free;
end;

procedure TFastContentProducerForm.btnDeleteProjectClick(Sender: TObject);
var INI: TBigINIFile;
begin
  if ProjectsList.ItemIndex > -1 then
   if Application.MessageBox(PChar('Are you sure you want to delete the project named "'+ProjectsList.Items[ProjectsList.ItemIndex].Caption+'"?'), 'Confirm Delete', MB_YESNO+MB_ICONQUESTION) = mrYes then
   begin
     INI := TBigINIFile.Create(ExtractFilePath(ParamStr(0))+'Projects.ini');
     INI.EraseSection(ProjectsList.Items[ProjectsList.ItemIndex].Caption);
     INI.Free;
     ProjectsList.Items.Delete(ProjectsList.ItemIndex);
   end;
end;

procedure TFastContentProducerForm.btnCreateNewProjectClick(Sender: TObject);
begin
  if Application.MessageBox('Save changes to the current project before proceeding?', 'Save Changes', MB_YESNO+MB_ICONINFORMATION) = mrYes then
    SaveCurrentProject;
  CreateNewProject;
  BigPages.ActivePageIndex := 0;
  MainPages.ActivePageIndex := 0;
  ProjectName.SetFocus;
end;

procedure TFastContentProducerForm.CreateNewProject;
begin
  ProjectName.Text := '';
  ContentFile.Text := '';
  PageTemplate.Text := '';
  OutputLocation.Text := '';
  CharsPerPage.Text := '';
  ContentType.ItemIndex := 0;
  PageBreak.Text := '';

  FeedsList.Items.Text := '';
  RSSURL.Text := '';
  AffiliateCodes.Lines.Text := '';

  FormCode.Lines.Text := '';
  BottomLinks.Lines.Text := '';
  KeywordLinks.Lines.Text := '';
  editLinkURL.Text := '';
  editLinkText.Text := '';

  HeaderTitle.Text := '';
  HeaderSlogan.Text := '';
  Prefix.Text := '';
  PrefixType.ItemIndex := 0;
  HeaderLogo.Text := '';
  HeaderOnPage.Text := '';

  HTMLPreview.LoadTextFromString('');
end;

procedure TFastContentProducerForm.btnRunProjectClick(Sender: TObject);
begin
  if ProjectsList.ItemIndex > -1 then
    RunProject(ProjectsList.Items[ProjectsList.ItemIndex].Caption);
end;

procedure TFastContentProducerForm.RunProject(ProjectName: String);
var ListOfAllPages, RSS, HTML, EntireContent, WordList, Tmp, List: TStringList;
    MyKeyword, MyLinkText, MyLinkURL, ArticleText, Suffix, OutputFilename, OutputFolder, S, S1: String;
    PagesTag, RowText: String;
    M, N, I, J, PerPage, TotalPages, TotalWords, TotalCharacters: Integer;
    INI: TBigINIFile;
begin
  { Run our project here }
  try
    if StrToInt(CharsPerPage.Text) < 0 then
     raise Exception.Create('');
  except
    Application.MessageBox('Please enter a valid number of characters/words per page!', 'Warning', MB_OK+MB_ICONWARNING);
    Exit;
  end;
  try
    if StrToInt(HeaderOnPage.Text) < 0 then
     raise Exception.Create('');
  except
    Application.MessageBox('Please enter a valid number of pages to place the header on!', 'Warning', MB_OK+MB_ICONWARNING);
    Exit;
  end;
  if not FileExists(PageTemplate.Text) then
  begin
    Application.MessageBox('Please select a valid template file!', 'Warning', MB_OK+MB_ICONWARNING);
    Exit;
  end;

  INI := TBigINIFile.Create(ExtractFilePath(ParamStr(0))+'Projects.ini');
  INI.WriteString(ProjectName, 'LastRun', DateTimeToStr(Now));
  INI.Free;

  EntireContent := TStringList.Create;
  WordList := TStringList.Create;
  List := TStringList.Create;
  Tmp := TStringList.Create;
  PBar.Percent := 0;

  ForceDirectories(ExtractFilePath(ParamStr(0))+'Temp');

  { Prepare our content and words }
  S := ContentFile.Text;
  while Pos('|', S) > 0 do
  begin
    S1 := Copy(S, 1, Pos('|', S)-1);
    Delete(S, 1, Length(S1)+1);
    if FileExists(S1) and (Trim(S1) <> '') then
    begin
      if (UpperCase(ExtractFileExt(S1))='.DOC') or (UpperCase(ExtractFileExt(S1))='.RTF') then
      begin
        SaveDOCasTEXT(S1, ExtractFilePath(ParamStr(0))+'Temp\Temp.txt');
        Tmp.LoadFromFile(ExtractFilePath(ParamStr(0))+'Temp\Temp.txt');
      end
      else
        Tmp.LoadFromFile(S1);
      List.Clear;
      EntireContent.AddStrings(Tmp); // add to entire content list
      Tmp.Text := StringReplace(Tmp.Text, #13#10, '<br> ', [rfReplaceAll]);
      SplitTextIntoWords(Tmp.Text, List);
      WordList.AddStrings(List); // add to the list of entire words
    end;
  end;
  if FileExists(S) and (Trim(S) <> '') then
  begin
    if (UpperCase(ExtractFileExt(S))='.DOC') or (UpperCase(ExtractFileExt(S))='.RTF') then
    begin
      SaveDOCasTEXT(S, ExtractFilePath(ParamStr(0))+'Temp\Temp.txt');
      Tmp.LoadFromFile(ExtractFilePath(ParamStr(0))+'Temp\Temp.txt');
    end
    else
      Tmp.LoadFromFile(S);
    List.Clear;
    EntireContent.AddStrings(Tmp); // add to entire content list
    Tmp.Text := StringReplace(Tmp.Text, #13#10, '<br> ', [rfReplaceAll]);
    SplitTextIntoWords(Tmp.Text, List);
    WordList.AddStrings(List); // add to the list of entire words
  end;
  Tmp.Free;
  // delete the temp folder
  DelDir(ExtractFilePath(ParamStr(0))+'Temp');

  { Determine how many files need to be created }
  PerPage := StrToInt(CharsPerPage.Text);
  TotalWords := WordList.Count;
  TotalCharacters := Length(EntireContent.Text);
  if ContentType.ItemIndex = 0 then
   if TotalCharacters mod PerPage = 0 then
    TotalPages := TotalCharacters div PerPage
   else
    TotalPages := (TotalCharacters div PerPage) + 1
  else
   if TotalCharacters mod PerPage = 0 then
    TotalPages := TotalWords div PerPage
   else
    TotalPages := (TotalWords div PerPage) + 1;

  if TotalPages <= 0 then
  begin
    Application.MessageBox('The program needs to create at least one page! Your current settings will determine it to create no pages.', 'Warning', MB_OK+MB_ICONWARNING);
    Exit;
  end;

  { Build the pages next }
  OutputFolder := OutputLocation.Text;
  if OutputFolder <> '' then
   if OutputFolder[Length(OutputFolder)] <> '\' then
    OutputFolder := OutputFolder + '\';
  if not DirectoryExists(OutputFolder) then
   ForceDirectories(OutputFolder); // build output directory
  ForceDirectories(OutputFolder+'Images'); // create image directory

  { Prepare image file }
  if FileExists(HeaderLogo.Text) and (Trim(HeaderLogo.Text) <> '') then
   CopyDir(HeaderLogo.Text, OutputFolder+'Images\'+ExtractFileName(HeaderLogo.Text));

  { build HTML text for each page }
  ListOfAllPages := TStringList.Create;
  HTML := TStringList.Create;
  for I:=1 to TotalPages do
  begin
    Application.ProcessMessages;
    PBar.Percent := Round((I * 100) / TotalPages);

    // load text from template page
    HTML.Clear;
    HTML.LoadFromFile(PageTemplate.Text);

    // prepare the output filename
    OutputFileName := '';
    OutputFilename := Prefix.Text;
    if PrefixType.ItemIndex = 0 then // we choose the first 3 (or less) words to work with
    begin
      Suffix := '';
      if WordList.Count < 2 then
       N := WordList.Count
      else
       N := 2;
      for J:=0 to N do
       Suffix := Suffix+'_'+WordList[J];
      for J:=1 to Length(Suffix) do
       if not (Suffix[J] in ['A'..'Z', 'a'..'z', '0'..'9']) then
        Suffix[J] := '_';
      OutputFileName := OutputFileName + Suffix; // we add the suffix
    end
    else
     OutputFileName := OutputFileName + IntToStr(I); // we add the number
    OutputFileName := OutputFileName+'.html';

    // replace strings
    HTML.Text := StringReplace(HTML.Text, '%JOBTITLE%', Self.ProjectName.Text, [rfReplaceAll, rfIgnoreCase]);

    RSS := TStringList.Create;
    RSS.LoadFromFile(ExtractFilePath(ParamStr(0))+'RSS.INI');
    if FeedsList.Count = 0 then
     RSS.Text := StringReplace(RSS.Text, '%RSSURL%', '', [rfReplaceAll, rfIgnoreCase])
    else
     RSS.Text := StringReplace(RSS.Text, '%RSSURL%', URLEncode(FeedsList.Items[(I-1) mod FeedsList.Count], False), [rfReplaceAll, rfIgnoreCase]);
    HTML.Text := StringReplace(HTML.Text, '%RSS%', RSS.Text, [rfReplaceAll, rfIgnoreCase]);
    RSS.Free;

    if (Trim(HeaderLogo.Text) <> '') and FileExists(HeaderLogo.Text) then
     if (I mod StrToInt(HeaderOnPage.Text) = 0) then
      HTML.Text := StringReplace(HTML.Text, '%HEADERIMAGE%', 'Images/'+ExtractFileName(HeaderLogo.Text), [rfReplaceAll, rfIgnoreCase])
     else
      HTML.Text := StringReplace(HTML.Text, '%HEADERIMAGE%', '', [rfReplaceAll, rfIgnoreCase])
    else
     HTML.Text := StringReplace(HTML.Text, '%HEADERIMAGE%', '', [rfReplaceAll, rfIgnoreCase]);

    HTML.Text := StringReplace(HTML.Text, '%HEADER%', HeaderTitle.Text, [rfReplaceAll, rfIgnoreCase]);

    HTML.Text := StringReplace(HTML.Text, '%SLOGAN%', HeaderSlogan.Text, [rfReplaceAll, rfIgnoreCase]);

    HTML.Text := StringReplace(HTML.Text, '%AFFILIATEFIRST%', AffiliateCodes.Lines.Text, [rfReplaceAll, rfIgnoreCase]);

    HTML.Text := StringReplace(HTML.Text, '%FORMCODE%', FormCode.Lines.Text, [rfReplaceAll, rfIgnoreCase]);

    HTML.Text := StringReplace(HTML.Text, '%BOTTOMLINKS%', BottomLinks.Lines.Text, [rfReplaceAll, rfIgnoreCase]);

    // prepare the article contents (%ARTICLE%)
    ArticleText := '';
    if ContentType.ItemIndex = 0 then // count characters
    begin
      if PerPage < Length(EntireContent.Text) then
       N := PerPage
      else
       N := Length(EntireContent.Text);
      for J:=1 to N do // build the article from characters
      begin
        if J=1 then
         ArticleText := EntireContent.Text[J]
        else
         ArticleText := ArticleText+EntireContent.Text[J];
      end;
      ArticleText := StringReplace(ArticleText, #13#10, '<br>', [rfReplaceAll]);
      // now delete the characters from our list, we don't need them anymore
      S := EntireContent.Text;
      Delete(S, 1, N);
      EntireContent.Text := S;
    end
    else
    begin // count words only
      if PerPage < WordList.Count then
       N := PerPage
      else
       N := WordList.Count;
      for J:=1 to N do // build the article from words
      begin
        if J=1 then
         ArticleText := WordList[J-1]
        else
         ArticleText := ArticleText+' '+WordList[J-1];
      end;
      J := 1; // now delete the words from our list, we don't need them anymore
      while J <= N do
      begin
        Inc(J);
        WordList.Delete(0);
      end;
    end;
    // now we replace the keyword links as specified in the software
    for J:=0 to KeywordLinks.Lines.Count-1 do
    begin
      S := KeywordLinks.Lines[J];
      MyKeyword := Copy(S, 1, Pos(',', S)-1);
      if Trim(MyKeyword) <> '' then
      begin
        Delete(S, 1, Pos(',', S));
        MyLinkText := Copy(S, 1, Pos('|', S)-1);
        Delete(S, 1, Pos('|', S));
        MyLinkURL := S;
        if (Trim(MyLinkText) <> '') and (Trim(MyLinkURL) <> '') then
        begin
          S := '<a href="'+MyLinkURL+'">'+MyLinkText+'</a>';
          ArticleText := StringReplace(ArticleText, MyKeyword, S, [rfReplaceAll, rfIgnoreCase]);
        end;
      end;
    end;
    HTML.Text := StringReplace(HTML.Text, '%ARTICLE%', ArticleText, [rfReplaceAll, rfIgnoreCase]);

    // save the page!
    HTML.SaveToFile(OutputFolder + OutputFileName);
    ListOfAllPages.Add(OutputFolder + OutputFileName); // we use this to link pages between each other
  end;

  { ------------------------------- Now let's link the pages one between another (%PAGES%) }
  for I:=0 to ListOfAllPages.Count-1 do
  begin
    HTML.Clear;
    HTML.LoadFromFile(ListOfAllPages[I]);

    // we now replace the %PAGES% tag
    PagesTag := '';
    if ListOfAllPages.Count > 1 then
     if I=0 then // next
     begin
       PagesTag := '<a href="'+ExtractFileName(ListOfAllPages[I+1])+'">Next Page >></a>';
     end
     else
      if I = ListOfAllPages.Count-1 then // previous
      begin
        PagesTag := '<a href="'+ExtractFileName(ListOfAllPages[I-1])+'"><< Previous Page</a>';
      end
      else // next & previous
      begin
        PagesTag := '<a href="'+ExtractFileName(ListOfAllPages[I-1])+'"><< Previous Page</a>&nbsp;&nbsp;&nbsp;&nbsp;'+
        '<a href="'+ExtractFileName(ListOfAllPages[I+1])+'">Next Page >></a>';
      end;
    HTML.Text := StringReplace(HTML.Text, '%PAGES%', PagesTag, [rfReplaceAll, rfIgnoreCase]);

    // save the file now again
    HTML.SaveToFile(ListOfAllPages[I]);
  end;

  { ------------------------------- Next, we create the INDEX.HTML with links to all the pages created }
  begin
    // load text from template page
    HTML.Clear;
    HTML.LoadFromFile(PageTemplate.Text);

    // replace strings
    HTML.Text := StringReplace(HTML.Text, '%JOBTITLE%', Self.ProjectName.Text, [rfReplaceAll, rfIgnoreCase]);

    RSS := TStringList.Create;
    RSS.LoadFromFile(ExtractFilePath(ParamStr(0))+'RSS.INI');
    if FeedsList.Count = 0 then
     RSS.Text := StringReplace(RSS.Text, '%RSSURL%', '', [rfReplaceAll, rfIgnoreCase])
    else
     RSS.Text := StringReplace(RSS.Text, '%RSSURL%', URLEncode(FeedsList.Items[0], False), [rfReplaceAll, rfIgnoreCase]);
    HTML.Text := StringReplace(HTML.Text, '%RSS%', RSS.Text, [rfReplaceAll, rfIgnoreCase]);
    RSS.Free;

    if (Trim(HeaderLogo.Text) <> '') and FileExists(HeaderLogo.Text) then
     HTML.Text := StringReplace(HTML.Text, '%HEADERIMAGE%', 'Images/'+ExtractFileName(HeaderLogo.Text), [rfReplaceAll, rfIgnoreCase])
    else
     HTML.Text := StringReplace(HTML.Text, '%HEADERIMAGE%', '', [rfReplaceAll, rfIgnoreCase]);

    HTML.Text := StringReplace(HTML.Text, '%HEADER%', HeaderTitle.Text, [rfReplaceAll, rfIgnoreCase]);

    HTML.Text := StringReplace(HTML.Text, '%SLOGAN%', HeaderSlogan.Text, [rfReplaceAll, rfIgnoreCase]);

    HTML.Text := StringReplace(HTML.Text, '%AFFILIATEFIRST%', AffiliateCodes.Lines.Text, [rfReplaceAll, rfIgnoreCase]);

    HTML.Text := StringReplace(HTML.Text, '%FORMCODE%', FormCode.Lines.Text, [rfReplaceAll, rfIgnoreCase]);

    HTML.Text := StringReplace(HTML.Text, '%BOTTOMLINKS%', BottomLinks.Lines.Text, [rfReplaceAll, rfIgnoreCase]);

    // prepare the article contents (%ARTICLE%) with links to all the pages
    // we need a table of 4 columns
    ArticleText := '';
    if TotalPages mod 4 = 0 then
     N := TotalPages div 4 // nr of rows
    else
     N := (TotalPages div 4) + 1; // nr of rows
    ArticleText := '<table width="96%" border="0" cellpadding="5" cellspacing="5">';
    M := 0;
    for I:=1 to N do
    begin
      RowText := '<tr>';
      for J:=1 to 4 do
      begin
        Inc(M);
        if ListOfAllPages.Count > 0 then
        begin
          RowText := RowText + '<th scope="col"><div align="left"><a href="'+ListOfAllPages[0]+'">Page #'+IntToStr(M)+'</a></div></th>';
          ListOfAllPages.Delete(0);
        end
        else
         RowText := RowText + '<th scope="col">&nbsp;</th>';
      end;
      RowText := RowText+'</tr>';
      ArticleText := ArticleText + RowText;
    end;
    ArticleText := ArticleText + '</table>';
    HTML.Text := StringReplace(HTML.Text, '%ARTICLE%', ArticleText, [rfReplaceAll, rfIgnoreCase]);

    // nothing here
    HTML.Text := StringReplace(HTML.Text, '%PAGES%', '', [rfReplaceAll, rfIgnoreCase]);

    // save the page!
    HTML.SaveToFile(OutputFolder + 'index.html');
  end;
  { ------------------------------- Next, we create the INDEX.HTML with links to all the pages created }

  { Finish up }
  HTML.Free;
  List.Free;
  WordList.Free;
  EntireContent.Free;
  ListOfAllPages.Free;

  { Completed! }
  Application.MessageBox(PChar('Approximately '+IntToStr(TotalPages)+' page(s) were created.'), 'Information', MB_OK+MB_ICONINFORMATION);
  // reset to 0
  PBar.Percent := 0;
end;

procedure TFastContentProducerForm.btnPreviewOnePageClick(Sender: TObject);
var OutputFolder: String;
begin
  OutputFolder := OutputLocation.Text;
  if OutputFolder <> '' then
   if OutputFolder[Length(OutputFolder)] <> '\' then
    OutputFolder := OutputFolder + '\';
  HTMLPreview.LoadFromFile(OutputFolder+'index.html');
end;

procedure TFastContentProducerForm.RzButton3Click(Sender: TObject);
begin
  ShellExecute(Handle, 'open', 'http://www.google.com', '', '', SW_SHOWNORMAL);
end;

end.
